;*********************************************************************
; DESCRIBTION :	THIS PROGRAM IS ROTATE RIGHT OF PORT 3 ON AT89C5131
; FILE NAME   : UART MODE1_INT_BRG.ASM
; COMPILER    : CROSS 32
; SUPPORT     : AT89C5131
; X'TAL	      : 24MHz
; BAUD RATE   : 115200bps
; DATE        : 6 SEPTEMBER 2004
; MODE	      : UART MODE1 INTERNAL BAUD RATE GENERATOR,NO USED INTERRUPT
;*********************************************************************
;	DEFINE SFRs
;*********************************************************************
;-----------    OTHER SFRs ---------------
CKCON0          EQU     8FH

;-----------    TWI SFRs ---------------
SSCON           EQU     93H
SSCS            EQU     94H
SSDAT           EQU     95H
SSADR           EQU     96H

;-----------    INTERRUPT SFRs ---------------
IEN1            EQU     0B1H

;-----------    BAUDRATE GENERATOR SFRs ---------------
BRL             EQU     9AH
BDRCON          EQU     9BH

;*********************************************************************
;	DEFINE SECTION
;*********************************************************************
BUFFER_RX	EQU	70H
COUNT_RX	EQU	6FH
;*********************************************************************

		ORG	0000H		; Reset vector
START:		LJMP	BEGIN

;************************************************
;		INTERRUPT SECTION
;************************************************

;************************************************
		ORG	0100H
		
BEGIN:		MOV     SP,#256-32              ; define stack = 32 byte
		ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	PCON,#11000000B		; ENABLE THE FRAMING BIT ERROR DETECTION, DOUBLE BAUD RATE
						; AND CHECK FE BIT OF SCON SFR
		ORL	BDRCON,#00001110B	; SPD=1,RBCK =1, TBCK =1
		MOV	SCON,#01010000B		; uart in mode 1 (8 bit), REN=1 
		MOV	BRL,#243		; U CAN SEE THIS VALUE FROM PAGE 71 OF DATASHEET
		ORL	BDRCON,#00010000B	; BRR = 1 , START BAUD RATE RUN
		;========================
		; TRANSMITION
		;========================
		MOV	DPTR,#TEXT_1
		ACALL	TRANSMIT

		;========================
		; RECEIVER
		;========================
		MOV	R0,#BUFFER_RX
		ACALL	RECEIVE

		MOV	A,R0
		MOV	R0,#BUFFER_RX
		;========================
		; TRANSMITION
		;========================
REPLY:		CLR	TI
		MOV	SBUF,@R0
		JNB	TI,$
		CLR	TI
		INC	R0
		CJNE	A,00H,REPLY		; 00H = RO
		;========================
		; SEND ENTER
		;========================
		MOV	DPTR,#ENTER
		ACALL	TRANSMIT
		JMP	BEGIN

;********************** ROUTINE: TX *****************************************
;			INPUT : DPTR		; DEFINE TEXT LOCATION
;			OUTPUT : -			
;****************************************************************************
TRANSMIT:	CLR	TI			; Clear TI
TX_LOOP:	CLR	A			; Clear ACC.
		MOVC	A,@A+DPTR		; Get Data from ROM with Pointer
		INC	DPTR			; Increase Pointer
		CJNE	A,#0FFH,TX_CHAR		; Check 0FFH End of Text Char.
		RET				; End => Return

TX_CHAR:	MOV	SBUF,A			; Send Data to SBUF
		JNB	TI,$			; Wait until TX already (TI=1)
		CLR	TI			; Clear TI
		AJMP	TX_LOOP			; Jump to TX_LOOP

;********************** ROUTINE: RX *****************************************
;			INPUT : R0		; DEFINE BUFFER ADDRESS
;			OUTPUT : ADDRESS 70H....			
;****************************************************************************

RECEIVE:	SETB	REN			; Set RX Enable
RE_LOOP:	JNB	RI,$			; Wait received 1 byte FROM KEY BOARD[ JUMP IF BIT RI = '0']
		CLR	RI			; CLEAR RECEIVE INTERRUPT FLAG
;		****************************
;		FRAMEING BIT ERROR DETECTION
;		****************************
		MOV	ACC,SCON
		CLR	SCON.7
		JB	ACC.7,RE_LOOP		; JUMP IF SCON.7(FE) = '1'
;		****************************
		MOV	A,SBUF			; Get byte from SBUF
		MOV	@R0,A			; KEEP 1 BYTE DATA TO MEMORY 70H
		CJNE	A,#0DH,INC_R0		; Check Enter key receive? [IF REG "A" UNEQUAL 0DH JUMP]
		RET
;		************************
;		COUNT THE AMOUNT WORDS
;		************************
INC_R0:		INC	R0			; Increase pointer
		AJMP	RE_LOOP			; Back to do loop

; ************************************************
;		SEND ENTER 
; ************************************************
ENTER:			DB	0AH,0DH,0FFH

; ************************************************
;		DELAY  
; ************************************************
DELAY:		MOV	R7,#50
D1:		MOV	R6,#50
D2:		NOP
		NOP	
		DJNZ	R6,D2
		DJNZ	R7,D1
		RET

; ************************************************
;		MESSAGE  
; ************************************************
TEXT_1:		DB 0AH,0DH
		DB "Please,Press any key.<15 Charactor are limited>",0AH,0DH,0FFH
		END